/*
    ---------------------------------------------------------------------------------------------
    ESP32-DevKitC von AZ-delivery: Mit dem asynchronen Webserver vom AccessPoint zum StationPoint
    ---------------------------------------------------------------------------------------------

    erster Neustart==>

    Wenn keine Verbindung zum Router-FritzBox aufgebaut werden kann:
    ----------------------------------------------------------------
    
    ==> ESP32 startet nach ca. 30Sekunden als AccessPoint mit Name: ESP_AccessPoint und dem dazugehörigen Passwort: 123456789

    ==> unter Windows-Einstellungen==> Netzwerk und Internet==> Status==> Eigenschaft von WLAN (ESP_Accesspoint), nach unten scrollen==> IPv4-DNS-Server: ===>> IP-Adresse kopieren und im Browser einfügen

    ==> SSID und SSID Passwort vom Router-Fritzbox eingeben

    ==> auf Button==> Eingabe speichern drücken

    ==> nun erscheint ein PopUp Fenster==> Button Ok zum speichern drücken==> und der ESP32  wird neu gestartet

    ==> die Daten für die Verbindung mit dem Router-Fritzbox, sind jetzt auf dem ESP32 im FlashSpeicher gespeichert

    ==> die aktuelle Verbindung wird unterbrochen, da der ESP32 jetzt kein AccessPoint mehr ist, sondern ein StationPoint, der sich mit dem Router-Fritzbox verbinden wird

    ==> Router-FritzBox wie gewohnt im Browser öffnen oder mit IP-Adresse: http://169.254.1.1/

    ==> in dem Browser-Fenster von dem Router-FritzBox unter==> WLAN==> Funknetz==> den ESP32 zu "Bekannte WLAN-Geräte im Funknetz" hinzufügen und die IP-Adresse: zum Beispiel: http://193.188.158.83 vom ESP32 kopieren

    ==> neues Fenster Browser öffnen

    ==> die kopierte IP-Adresse: zum Beispiel: http://193.188.158.83 vom ESP32 einfügen

    ==> Es wird ein Webseite für weitere Eingaben angezeigt <==



    Wird der ESP32 jetzt neu eingeschaltet oder neu gestartet:
    ----------------------------------------------------------

    ==> verbindet er sich automatisch mit dem Netzwerk, bzw. Router-Fritzbox

    ==> neues Fenster Browser öffnen

    ==> die jetzt schon bekannte IP-Adresse: zum Beispiel: http://193.188.158.83 vom ESP32 einfügen

    ==> Es wird ein Webseite für weitere Eingaben angezeigt <==


*/



/*--------------------------------------------------Bibliotheken--------------------------------------------------*/

//Wifi
#include <WiFi.h>
String Wifi_Status;

//Webserver-asynchron
#include <AsyncTCP.h>
#include <ESPAsyncWebServer.h>
AsyncWebServer server(80);

//FlashSpeicher
#include <Preferences.h>
Preferences preferences;

//MQTT
#include <PubSubClient.h>
#include <Wire.h>
WiFiClient MyClient;
PubSubClient MQTTclient(MyClient);

  
/*--------------------------------------------------Variablen--------------------------------------------------*/
// Variablen für die Taster
unsigned long lastDebounceTime1 = 0;           // Zeit, als der Taster 1 zuletzt überprüft wurde
unsigned long lastDebounceTime2 = 0;           // Zeit, als der Taster 2 zuletzt überprüft wurde
unsigned long lastDebounceTime3 = 0;           // Zeit, als der Taster 3 zuletzt überprüft wurde

const unsigned long debounceDelay = 50;        // Entprell-Zeit in Millisekunden

// Taster Konfiguration
const int TASTER_PIN1 = 19;                    // Taster 1 Pin
const int TASTER_PIN2 = 34;                    // Taster 2 Pin
const int TASTER_PIN3 = 35;                    // Taster 3 Pin

int tasterStatus1 = HIGH;                      // Standardwert für Taster 1: HIGH
int tasterStatus2 = HIGH;                      // Standardwert für Taster 2: HIGH
int tasterStatus3 = HIGH;                      // Standardwert für Taster 3: HIGH

int lastTasterStatus1 = HIGH;                  // Letzter Status für Taster 1
int lastTasterStatus2 = HIGH;                  // Letzter Status für Taster 2
int lastTasterStatus3 = HIGH;                  // Letzter Status für Taster 3

const char* mqtt_topic1 = "7seg/Taster1";      // MQTT-Topic für Taster 1
const char* mqtt_topic2 = "7seg/Taster2";      // MQTT-Topic für Taster 2
const char* mqtt_topic3 = "7seg/Taster3";      // MQTT-Topic für Taster 3

//Variablen-AccessPoint
#define AccessPoint_SSID "ESP_AccessPoint"			    //"xxx" ==> Name eintragen
#define AccessPoint_SSID_PASSWORT "123456789"		    //"xxx" ==> Passwort eintragen

//Variablen==> get von AccessPoint
const char* PARAM_SSID = "input_SSID";
const char* PARAM_SSID_PASSWORT = "input_SSID_PASSWORT";
const char* PARAM_IP_MQTT_Broker = "input_IP_MQTT_Broker";
const char* PARAM_Topic_1 = "input_Topic_1";
const char* PARAM_Topic_2 = "input_Topic_2";
const char* PARAM_Topic_3 = "input_Topic_3";

// Funktionsdeklaration
void checkTaster(int tasterPin, int &tasterStatus, int &lastTasterStatus, unsigned long &lastDebounceTime, unsigned long currentTime, const char* mqtt_topic);
void MQTTclientReconnect();

//Variablen-StationPoint==> get von Flashspeicher
String ssid_WiFi_gespeichert;
String ssid_WiFi_PasWo_gespeichert;
String IP_MQTT_Broker_gespeichert;
String Topic_1_gespeichert;
String Topic_2_gespeichert;
String Topic_3_gespeichert;

// Variablen für den MQTT-Broker
char char_IP_MQTT_Broker[31];
char char_Topic_1[61];
char char_Topic_2[61];
char char_Topic_3[61];

// Timer für MQTTclient.loop()
#define Zeit_MQTT_next 600              // Timer für MQTTclient.loop();
unsigned long Zeit_MQTT = 0;            // millis() speichern

// Portpinne Ausgänge
const int minus = 18;
const int komma0 = 21;
const int komma1 = 22;
const int komma2 = 23;
/*--------------------------------------------------Pinout--------------------------------------------------*/

uint8_t i=1;                    //Zähler für 7Segment-Anzeigen, von Anzeige Nr.1 bis Nr.4

//pinout Segmente
#define PIN_SEG_A 32            //Pinnummer für Segment A eintragen
#define PIN_SEG_B 33            //Pinnummer für Segment B eintragen
#define PIN_SEG_C 25            //Pinnummer für Segment C eintragen
#define PIN_SEG_D 26            //Pinnummer für Segment D eintragen
#define PIN_SEG_E 27            //Pinnummer für Segment E eintragen
#define PIN_SEG_F 14            //Pinnummer für Segment F eintragen
#define PIN_SEG_G 13            //Pinnummer für Segment G eintragen

//pinout Anzeige
#define PIN_Anzeige_1 17        //Pinnummer für Anzeige 1 eintragen
#define PIN_Anzeige_2 16        //Pinnummer für Anzeige 2 eintragen
#define PIN_Anzeige_3 4         //Pinnummer für Anzeige 3 eintragen
#define PIN_Anzeige_4 2         //Pinnummer für Anzeige 4 eintragen









/*--------------------------------------------------Multiplexing--------------------------------------------------*/

//Multiplexing
#define time_Multiplex  3                 //Geschwindigkeit Multiplexing in ms
unsigned long ZeitStartMultiplex = 0;     //millis() speichern


//def_7_Segment Anzeige Multiplexing
const unsigned char SegBitMap[] = {
//   abcdefg
  0b01111110, //0 = Wert_Anzeige_x = 0;
  0b00110000, //1 = Wert_Anzeige_x = 1;
  0b01101101, //2 = Wert_Anzeige_x = 2;
  0b01111001, //3 = Wert_Anzeige_x = 3;
  0b00110011, //4 = Wert_Anzeige_x = 4;
  0b01011011, //5 = Wert_Anzeige_x = 5;
  0b01011111, //6 = Wert_Anzeige_x = 6;
  0b01110000, //7 = Wert_Anzeige_x = 7;
  0b01111111, //8 = Wert_Anzeige_x = 8;
  0b01111011, //9 = Wert_Anzeige_x = 9;
  0b01110111, //A = Wert_Anzeige_x = 10;
  0b00011111, //b = Wert_Anzeige_x = 11;
  0b01001110, //C = Wert_Anzeige_x = 12;
  0b00111101, //d = Wert_Anzeige_x = 13;
  0b01001111, //E = Wert_Anzeige_x = 14;
  0b01000111, //F = Wert_Anzeige_x = 15;
  0b00000001, //- = Wert_Anzeige_x = 16;
  0b00000000, //leer  = Wert_Anzeige_x = 17;
  0b11111111, //alle  = Wert_Anzeige_x = 18;
};

//Wert_Anzeige_x
uint8_t Wert_Anzeige_1 = 0;
uint8_t Wert_Anzeige_2 = 0;
uint8_t Wert_Anzeige_3 = 0;
uint8_t Wert_Anzeige_4 = 0;

//pin_def_Segmente in Array ablegen
const unsigned char Seg_Bits[] = {PIN_SEG_G, PIN_SEG_F, PIN_SEG_E, PIN_SEG_D, PIN_SEG_C, PIN_SEG_B, PIN_SEG_A};

//Diese Funktion schreibt das SegBitMap zur Zahl "val" entsprechend der definierten HW-Pins (definiert in Seg_Bits[]) mit "1" oder "0" auf die Pins.
void Anzeige(unsigned char val){
  unsigned char i = 0;
  for (i = 0; i < 7; i++){
    if ( (SegBitMap[val] & (0x01 << i) ) != 0) 
      digitalWrite(Seg_Bits[i], 0);//1<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<anode-katode 0 oder 1
    else 
      digitalWrite(Seg_Bits[i], 1);//0<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<anode-katode 1 oder 0
  }
}





/*--------------------------------------------------Webseite--------------------------------------------------*/

//HTML Webseite==> AccessPoint
const char index_html_1[] PROGMEM = R"rawliteral(<!DOCTYPE HTML><html> <head> <meta charset='UTF-8'> <meta name='viewport' content='width=device-width, initial-scale=1'> <title>ESP-AccesessPoint</title> <style> body{ margin:0; font-family:'Segoe UI',Arial; color:#FFFFFF; background-color:#548235; } div { padding: 0px 0px 0px 30px; } </style> <script> function submitMessage() { alert("Ihre Eingaben werden gespeichert"); setTimeout(function(){ document.location.reload(false); }, 500); } </script> </head> <body> <div> <h1>ESP-AccessPoint</h1> <form action="/get" target="hidden-form"> SSID eingeben: <br/> <input type="text" name="input_SSID"><br><br> SSID Passwort eingeben: <br> <input type="number " name="input_SSID_PASSWORT"><br><br> <input type="submit" value="Eingabe speichern" onclick="submitMessage()"> </form><br> </div> <iframe style="display:none" name="hidden-form"></iframe> </body></html>)rawliteral";

//HTML Webseite==> StationPoint
const char index_html_2[] PROGMEM = R"rawliteral(<!DOCTYPE HTML><html> <head> <meta charset='UTF-8'> <meta name='viewport' content='width=device-width, initial-scale=1'> <title>ESP-StationPoint </title> <style> body{ margin:0; font-family:'Segoe UI',Arial; color:#FFFFFF; background-color:#4472C4; } div { padding: 0px 0px 0px 30px; } </style> <script> function submitMessage() { alert("Ihre Eingaben werden gespeichert"); setTimeout(function(){ document.location.reload(false); }, 500); } </script> </head> <body> <div> <h1>ESP-StationPoint</h1> <form action="/get" target="hidden-form"> IP MQTT Broker eingeben: <br/> <input type="text" name="input_IP_MQTT_Broker"> <br> <br> Topic 1 eingeben: <br> <input type="text " name="input_Topic_1"> <br> <br> Topic 2 eingeben: <br> <input type="text " name="input_Topic_2"> <br><br> Topic 3 eingeben: <br> <input type="text " name="input_Topic_3"> <br> <br> <input type="submit" value="Eingabe speichern" onclick="submitMessage()"> </form> <br> </div> <iframe style="display:none" name="hidden-form"></iframe> </body></html>)rawliteral";


void notFound(AsyncWebServerRequest *request) {
  request->send(404, "text/plain", "Not found");
}




/*--------------------------------------------------MQTT--------------------------------------------------*/

//MQTT
void callback(char* topic, byte* payload, unsigned int length){
  String sPayload = "";
  float fPayload = 0.0;

  Serial.print("Nachricht erreicht [");
  Serial.print(topic);
  Serial.print("] ");

  for (int i = 0; i < length; i++){
    sPayload += (char)payload[i];
  }
  Serial.println(sPayload);
  fPayload = sPayload.toFloat(); //Zahlenwert des Topics




 // Topic auswerten
Topic_1_gespeichert.toCharArray(char_Topic_1, sizeof(char_Topic_1)); // umwandeln von String zu char array

if (strcmp(topic, char_Topic_1) == 0) { // prüfen, welches Topic empfangen wurde
    int y = fPayload * 100; // fPayload kann negativ sein

    // Überprüfen, ob y negativ oder positiv ist
    bool isNegative = (y < 0);
    bool isPositive = (y > 0);

        if (isNegative) {
        Serial.println("Negativer Wert");
        digitalWrite (minus, HIGH);
    } else if (isPositive) {
        Serial.println("Positiver Wert");
        digitalWrite (minus, LOW);
    } else {
        Serial.println("Der Wert ist null");
    }

    // Absolute Werte für die Ziffernberechnung verwenden
    int absY = abs(y);

    Wert_Anzeige_1 = (absY / 1000) % 10;
    Wert_Anzeige_2 = (absY / 100) % 10;
    Wert_Anzeige_3 = (absY / 10) % 10;
    Wert_Anzeige_4 = absY % 10;

    //komma setzen
    digitalWrite (komma0, LOW);
    digitalWrite (komma1, LOW);
    digitalWrite (komma2, HIGH);


}

 // Topic auswerten
Topic_2_gespeichert.toCharArray(char_Topic_2, sizeof(char_Topic_2)); // umwandeln von String zu char array

if (strcmp(topic, char_Topic_2) == 0) { // prüfen, welches Topic empfangen wurde
    int y = fPayload * 100; // fPayload kann negativ sein

    // Überprüfen, ob y negativ oder positiv ist
    bool isNegative = (y < 0);
    bool isPositive = (y > 0);

    
    if (isNegative) {
        Serial.println("Negativer Wert");
        digitalWrite (minus, HIGH);
    } else if (isPositive) {
        Serial.println("Positiver Wert");
        digitalWrite (minus, LOW);
    } else {
        Serial.println("Der Wert ist null");
    }

    // Absolute Werte für die Ziffernberechnung verwenden
    int absY = abs(y);

    Wert_Anzeige_1 = (absY / 1000) % 10;
    Wert_Anzeige_2 = (absY / 100) % 10;
    Wert_Anzeige_3 = (absY / 10) % 10;
    Wert_Anzeige_4 = absY % 10;

    //komma setzen
    digitalWrite (komma0, LOW);
    digitalWrite (komma1, HIGH);
    digitalWrite (komma2, LOW);
  

}


 // Topic auswerten
Topic_3_gespeichert.toCharArray(char_Topic_3, sizeof(char_Topic_3)); // umwandeln von String zu char array

if (strcmp(topic, char_Topic_3) == 0) { // prüfen, welches Topic empfangen wurde
    int y = fPayload * 100; // fPayload kann negativ sein

    // Überprüfen, ob y negativ oder positiv ist
    bool isNegative = (y < 0);
    bool isPositive = (y > 0);

        if (isNegative) {
        Serial.println("Negativer Wert");
        digitalWrite (minus, HIGH);
    } else if (isPositive) {
        Serial.println("Positiver Wert");
        digitalWrite (minus, LOW);
    } else {
        Serial.println("Der Wert ist null");
    }

    // Absolute Werte für die Ziffernberechnung verwenden
    int absY = abs(y);

    Wert_Anzeige_1 = (absY / 1000) % 10;
    Wert_Anzeige_2 = (absY / 100) % 10;
    Wert_Anzeige_3 = (absY / 10) % 10;
    Wert_Anzeige_4 = absY % 10;

    //komma setzen
    digitalWrite (komma0, HIGH);
    digitalWrite (komma1, LOW);
    digitalWrite (komma2, LOW);

    
  
  }
}


//string umwandeln
void MQTTclientReconnect() 
{
  if(Wifi_Status != "AccessPoint"){//nur Verbindung aufbauen, wenn StationPoint
    while (MQTTclient.state() != MQTT_CONNECTED)
    {
      Serial.println("Verbinde zum Broker...");
      if (MQTTclient.connect("MQTT_ESP")) {
        Serial.println("OK - verbunden");

      /*Topic_1==> Subscribe (abonieren)
      -------------------------------------------------------------------------------------------------------------*/
      //if(MQTTclient.subscribe(MQTT_TOPIC_1)){
        Topic_1_gespeichert.toCharArray(char_Topic_1, sizeof(char_Topic_1));//umwandeln von String zu char array
      if(MQTTclient.subscribe(char_Topic_1)){
          Serial.println("Subscribe 'char_Topic_1' erfolgreich.");
        }
        else{
          Serial.println("Subscribe 'char_Topic_1' fehlgeschlagen.");
        }

      /*Topic_2==> Subscribe (abonieren)
      -------------------------------------------------------------------------------------------------------------*/
      //if(MQTTclient.subscribe(MQTT_TOPIC_2)){
        Topic_2_gespeichert.toCharArray(char_Topic_2, sizeof(char_Topic_2));//umwandeln von String zu char array
      if(MQTTclient.subscribe(char_Topic_2)){
          Serial.println("Subscribe 'char_Topic_2' erfolgreich.");
        }
        else{
          Serial.println("Subscribe 'char_Topic_2' fehlgeschlagen.");
        }

              /*Topic_3==> Subscribe (abonieren)
      -------------------------------------------------------------------------------------------------------------*/
      //if(MQTTclient.subscribe(MQTT_TOPIC_3)){
        Topic_3_gespeichert.toCharArray(char_Topic_3, sizeof(char_Topic_3));//umwandeln von String zu char array
      if(MQTTclient.subscribe(char_Topic_3)){
          Serial.println("Subscribe 'char_Topic_3' erfolgreich.");
        }
        else{
          Serial.println("Subscribe 'char_Topic_3' fehlgeschlagen.");
        }
      } 
      else{
        Serial.print("Fehler!, ReturnCode=");
        Serial.println(MQTTclient.state());
        esp_restart(); // Call the reset function
        delay(3000);
      }
    }
  }
}












/*--------------------------------------------------setup--------------------------------------------------*/

void setup() {
  Serial.begin(115200);
 
  // Taster-Pins als Eingänge konfigurieren
  pinMode(TASTER_PIN1, INPUT);
  pinMode(TASTER_PIN2, INPUT);
  pinMode(TASTER_PIN3, INPUT);

 //FlashSpeicher
  preferences.begin("credentials",false);
  preferences.putString("StatusWifi","StationPoint");                             //StatusWiFi in Flash speichern==> StationPoint
  Wifi_Status = preferences.getString("StatusWifi","");                           //StatusWiFi      aus Flash laden
  ssid_WiFi_gespeichert = preferences.getString("ssid_WiFi","");                  //ssid_Wifi       aus Flash laden
  ssid_WiFi_PasWo_gespeichert = preferences.getString("ssid_WiFi_PasWo","");      //ssid_WiFi_PasWo aus Flash laden
  IP_MQTT_Broker_gespeichert = preferences.getString("IP_MQTT_Broker","");        //IP_MQTT_Broker  aus Flash laden
  Topic_1_gespeichert = preferences.getString("Topic_1","");                      //Topic_1         aus Flash laden
  Topic_2_gespeichert = preferences.getString("Topic_2","");                      //Topic_2         aus Flash laden
  Topic_3_gespeichert = preferences.getString("Topic_3","");                      //Topic_3         aus Flash laden
  preferences.end();

  Serial.println(Wifi_Status);
  Serial.println(ssid_WiFi_gespeichert);
  Serial.println(ssid_WiFi_PasWo_gespeichert);
  Serial.println(IP_MQTT_Broker_gespeichert);
  Serial.println(Topic_1_gespeichert);
  Serial.println(Topic_2_gespeichert);
  Serial.println(Topic_3_gespeichert);

  //StationPoint
  WiFi.begin(ssid_WiFi_gespeichert, ssid_WiFi_PasWo_gespeichert);

  //Access-Point==> wenn nach 30 versuchen, ca.30Sekunden keine Verbindung zum Station-Point aufgebaut werden kann:
  byte tries = 0;
  while (WiFi.status() != WL_CONNECTED) {
    delay(1000);
    if (tries++ > 30) {
      WiFi.mode(WIFI_AP);
      WiFi.softAP(AccessPoint_SSID, AccessPoint_SSID_PASSWORT);
      //StatusVerbindung AccesPoint oder StationPoint speichern
      preferences.begin("credentials",false);
      preferences.putString("StatusWifi","AccessPoint");                        //StatusWiFi in Flash speichern==> AccessPoint
      Wifi_Status = preferences.getString("StatusWifi","");
      Serial.println(Wifi_Status);
      preferences.end();
      break;
    }
  }

  //Wenn AccessPiont:
  if(Wifi_Status==String("AccessPoint")){                                       //WebSeite für AccessPoint aufrufen
    server.on("/", HTTP_GET, [](AsyncWebServerRequest *request){
      request->send_P(200, "text/html", index_html_1);
    });
  }
  //Wenn StationPiont:
  if(Wifi_Status==String("StationPoint")){                                      //WebSeite für StationPoint aufrufen
    server.on("/", HTTP_GET, [](AsyncWebServerRequest *request){
      request->send_P(200, "text/html", index_html_2);
    });
  }


  // Send a GET request to <ESP_IP>/get?inputString=<inputMessage>
  server.on("/get", HTTP_GET, [] (AsyncWebServerRequest *request) {
    String inputMessage;
    // GET inputString value on <ESP_IP>/get?inputString=<inputMessage>
    if (request->hasParam(PARAM_SSID)) {
      inputMessage = request->getParam(PARAM_SSID)->value();
      preferences.begin("credentials",false);
      preferences.putString("ssid_WiFi",inputMessage);                            //ssid_WiFi in Flash speichern
      preferences.end();
      Serial.println(inputMessage);
    }
    // GET inputString value on <ESP_IP>/get?inputString=<inputMessage>
    if (request->hasParam(PARAM_SSID_PASSWORT)) {
      inputMessage = request->getParam(PARAM_SSID_PASSWORT)->value();
      preferences.begin("credentials",false);
      preferences.putString("ssid_WiFi_PasWo",inputMessage);                      //ssid_WiFi_PasWo in Flash speichern
      preferences.end();
      Serial.println(inputMessage);
    }
    // GET inputString value on <ESP_IP>/get?inputString=<inputMessage>
    if (request->hasParam(PARAM_IP_MQTT_Broker)) {
      inputMessage = request->getParam(PARAM_IP_MQTT_Broker)->value();
      preferences.begin("credentials",false);
      preferences.putString("IP_MQTT_Broker",inputMessage);                       //IP_MQTT_Broker in Flash speichern
      preferences.end();
      Serial.println(inputMessage);
    }
    // GET inputString value on <ESP_IP>/get?inputString=<inputMessage>
    if (request->hasParam(PARAM_Topic_1)) {
      inputMessage = request->getParam(PARAM_Topic_1)->value();
      preferences.begin("credentials",false);
      preferences.putString("Topic_1",inputMessage);                              //Topic_1 in Flash speichern
      preferences.end();
      Serial.println(inputMessage);
    }
    // GET inputString value on <ESP_IP>/get?inputString=<inputMessage>
    if (request->hasParam(PARAM_Topic_2)) {
      inputMessage = request->getParam(PARAM_Topic_2)->value();
      preferences.begin("credentials",false);
      preferences.putString("Topic_2",inputMessage);                              //Topic_2_PasWo in Flash speichern
      preferences.end();
      Serial.println(inputMessage);
    }
    // GET inputString value on <ESP_IP>/get?inputString=<inputMessage>
    if (request->hasParam(PARAM_Topic_3)) {
      inputMessage = request->getParam(PARAM_Topic_3)->value();
      preferences.begin("credentials",false);
      preferences.putString("Topic_3",inputMessage);                              //Topic_3_PasWo in Flash speichern
      preferences.end();
      Serial.println(inputMessage);
    }
 
    else {
      inputMessage = "No message sent";
    }
    
    request->send(200, "text/text", inputMessage);
    delay(50);
    esp_restart();                                                                //ESP32 nach neuer Eingabe im WebBrowser==> Reset neu starten
  });
  server.onNotFound(notFound);
  server.begin();



  //MQTT
  IP_MQTT_Broker_gespeichert.toCharArray(char_IP_MQTT_Broker, sizeof(char_IP_MQTT_Broker)); //umwandeln von String zu char array
  MQTTclient.setServer(char_IP_MQTT_Broker, 1883);
  
  MQTTclient.setCallback(callback);
  MQTTclientReconnect(); //erste Verbindung herstellen.
 





  //pin_layout
  pinMode(PIN_SEG_A, OUTPUT);
  pinMode(PIN_SEG_B, OUTPUT);
  pinMode(PIN_SEG_C, OUTPUT);
  pinMode(PIN_SEG_D, OUTPUT);
  pinMode(PIN_SEG_E, OUTPUT);
  pinMode(PIN_SEG_F, OUTPUT);
  pinMode(PIN_SEG_G, OUTPUT);

  pinMode(PIN_Anzeige_1, OUTPUT);
  pinMode(PIN_Anzeige_2, OUTPUT);
  pinMode(PIN_Anzeige_3, OUTPUT);
  pinMode(PIN_Anzeige_4, OUTPUT);
  
  //Timer
  ZeitStartMultiplex = millis() + time_Multiplex;
  Zeit_MQTT = millis();




 pinMode (minus, OUTPUT);
 pinMode (komma0, OUTPUT);
 pinMode (komma1, OUTPUT);
 pinMode (komma2, OUTPUT);
}








void loop() {
/*
  //FlashSpeicher==> Status WiFi abholen
  preferences.begin("credentials",false);
  Wifi_Status = preferences.getString("StatusWifi","");
  Serial.println(Wifi_Status);
  preferences.end();

  //IP-Adresse
  if (WiFi.status() == WL_CONNECTED) {
    Serial.print("IP Address: ");
    Serial.println(WiFi.localIP());
  }
  
  //
  Serial.println("done");
  Serial.println();
  delay(1000);


*/
 unsigned long currentTime = millis();        // Aktuelle Zeit erfassen

  // Taster 1 prüfen
  checkTaster(TASTER_PIN1, tasterStatus1, lastTasterStatus1, lastDebounceTime1, currentTime, mqtt_topic1);
  
  // Taster 2 prüfen
  checkTaster(TASTER_PIN2, tasterStatus2, lastTasterStatus2, lastDebounceTime2, currentTime, mqtt_topic2);

  // Taster 3 prüfen
  checkTaster(TASTER_PIN3, tasterStatus3, lastTasterStatus3, lastDebounceTime3, currentTime, mqtt_topic3);

  }

  
// Funktion zum Prüfen und Senden der MQTT-Nachricht
void checkTaster(int tasterPin, int &tasterStatus, int &lastTasterStatus, unsigned long &lastDebounceTime, unsigned long currentTime, const char* mqtt_topic) {
  int reading = digitalRead(tasterPin);        // Tasterstatus abfragen

  if ((currentTime - lastDebounceTime) > debounceDelay) {  // Entprellen
    if (reading != lastTasterStatus) {         // Nur wenn der Status sich geändert hat
      lastDebounceTime = currentTime;          // Zeit des letzten Statuswechsels speichern

      if (reading == HIGH) {
        // Taster gedrückt, sende "1"
        Serial.print(mqtt_topic);
        Serial.println(" gedrückt - sende '1'");
        MQTTclient.publish(mqtt_topic, "1");
      } else {
        // Taster losgelassen, sende "0"
        Serial.print(mqtt_topic);
        Serial.println(" losgelassen - sende '0'");
        MQTTclient.publish(mqtt_topic, "0");
      }
      lastTasterStatus = reading;             // Status aktualisieren
    }
  }



  //MQTT
  if (millis() >= (Zeit_MQTT + Zeit_MQTT_next) ){
    if (MQTTclient.state() != MQTT_CONNECTED){
      MQTTclientReconnect();//MQTT-Clientverbindung nicht (mehr) gegeben. Neu versuchen...
    }
    else{

      MQTTclient.loop();
    }
    Zeit_MQTT = millis();
  }


  //Multiplexing_Anzeige_1
  if (i==1 && millis() >= ZeitStartMultiplex){ 
    digitalWrite(PIN_Anzeige_4, 0);//Anzeige 4 ausschalten (vom vorherigen Durchlauf!)
    digitalWrite(PIN_Anzeige_1, 1);//Anzeige 1 einschalten
    Anzeige(Wert_Anzeige_1);
    i=2;
  }

  //Multiplexing_Anzeige_2
  if (i==2 && millis() >= (ZeitStartMultiplex + 1 * time_Multiplex) ){ 
    digitalWrite(PIN_Anzeige_1, 0);//Anzeige 1 ausschalten
    digitalWrite(PIN_Anzeige_2, 1);//Anzeige 2 einschalten
    Anzeige(Wert_Anzeige_2);
    i=3;
  }

  //Multiplexing_Anzeige_3
  if (i==3 && millis() >= (ZeitStartMultiplex + 2 * time_Multiplex) ){ 
    digitalWrite(PIN_Anzeige_2, 0);//Anzeige 2 ausschalten
    digitalWrite(PIN_Anzeige_3, 1);//Anzeige 3 einschalten
    Anzeige(Wert_Anzeige_3);
    i=4;
  }

  //Multiplexing_Anzeige_4
  if (i==4 && millis() >= (ZeitStartMultiplex + 3 * time_Multiplex) ){ 
    digitalWrite(PIN_Anzeige_3, 0);//Anzeige 3 ausschalten
    digitalWrite(PIN_Anzeige_4, 1);//Anzeige 4 einschalten
    Anzeige(Wert_Anzeige_4);
    i=1;
    //neuen Startpunkt merken
    ZeitStartMultiplex = millis() + time_Multiplex;
  }


}








